
from OpenGL.GL import *
from glew import *

def create(width, height):

    global program

    glewGetExtension("GL_ARB_fragment_shader")
    glewGetExtension("GL_ARB_shader_objects")
    glewGetExtension("GL_ARB_shading_language_100")


    fragsource = """

    sampler2D tex1, tex2;

    vec4 sample1(float x, float y) {
        return texture2DLod(tex1, gl_TexCoord[0].xy + vec2(x/%f, y/%f), 10.0);
    }

    vec4 sample2(float x, float y) {
        return texture2DLod(tex2, gl_TexCoord[0].xy + vec2(x/%f, y/%f), 10.0);
    }
    
    void main(void) {
        vec4 colOut = vec4(0, 0, 0, 0);
        int i;
        float totalWeight = 0;
        for (i = 1; i < 40; i+=2) {            
            vec4 colSample = (30*sample1(i, 0) - sample1(i+1, 0) - sample1(i-1, 0))/28;
            vec4 colOld = (30*sample2(i, 0) - sample2(i+1, 0) - sample2(i-1, 0))/28;            

            vec4 colDelta = colSample - colOld;            
            float weight = dot(colSample, colOld) * exp(-2*dot(colDelta, colDelta));
            totalWeight += weight;
            colOut += weight * colSample;
        }
        gl_FragColor = colOut / totalWeight;
    }
    
    """ % (width, height, width, height)

    fragshader = glCreateShaderObjectARB(GL_FRAGMENT_SHADER_ARB)
    glFlush()
    glShaderSourceARB(fragshader, 1, [fragsource])
    glFlush()
    
    glCompileShaderARB(fragshader)
    glGetObjectParameterivARB(fragshader, GL_OBJECT_COMPILE_STATUS_ARB)
    print glGetInfoLogARB(fragshader)
    
    program = glCreateProgramObjectARB()
    glFlush()

    glAttachObjectARB(program, fragshader)
    glFlush()

    glLinkProgramARB(program)
    glFlush()

    print glGetInfoLogARB(program)
    glFlush()

          
def enable():
    global program
    glUseProgramObjectARB(program)
    glFlush()
          
def disable():
    glUseProgramObjectARB(0)
    glFlush()


